
#include "lib/presets.h"

// Don't Change this.This is Function.
#define GetShadow(a,b,c,d) mix(a, b, max(c,max(d,-d)))
#define GetLight(a,b,c) mix(a,b,max(c,-c))

// You can change this.Happy Coding ^_^

#define exposure 1.115 // Exposure Value. Bigger value,More bright ( default is 1.115 ) [ 1.115, 1.25, 1.5 ]

#define saturation 1.115 // Saturation Value. Bigger value,More saturated ( default is 1.115 ) [ 1.115, 1.25,, 1.75 ]

#define CausticIntensity 4.0 // Caustic intensity. Bigger value, More bright the Caustic ( default is 4.0 ) [ 4.0, 4.5, 5.0 ]

vec3 HDR ( vec3 indiff ){
    
    indiff = mix(indiff * .5, indiff * 1.5, indiff);
    
    indiff = clamp(indiff, vec3(.0), vec3(1.));
    return indiff;
}

vec3 GetGrayscale( vec3 diff, const float set ){
    float grayscale = dot(diff, vec3(.2126, .7156, .0722));
    
    return mix(diff, vec3(grayscale), set);
}

vec3 curve(vec3 x) {
    
    const vec3 A = vec3(2.8);
    const vec3 B = vec3(.5);
    const vec3 C = vec3(2.2);
    const vec3 D = vec3(2.1);
    const vec3 E = vec3(.02);
    const vec3 F = vec3(1.);
    return ((x * (A * x + C * B) + D * E) / (x * (A * x + B) + D * F)) - E / F;

} 

vec3 Contrast( vec3 color, const float contrast ){
    
	float colorLength = length(color);
	vec3 nColor = color / colorLength;
	colorLength = pow(colorLength, contrast);
	return nColor * colorLength;
}

vec3 tone(vec3 clr) {
    

    vec3 Whitescale = vec3(2.) / vec3(1.);
    clr *= vec3(exposure);
    
    float Luma = dot(clr.rgb, vec3(.2125, .7154, .0721));
    vec3 Chroma = clr - Luma;
    
    clr = ( Chroma * vec3(saturation)) + Luma;
    
    clr = curve(clr) / curve(Whitescale);

    return clr;
}

void GetAo( inout vec3 indiff, in vec4 inclr, in float light){
    
    vec3 ao;
    
    if(inclr.g*2. > inclr.r + inclr.b){
        #if defined(ALPHA_TEST) && !defined(BLEND)
        ao = inclr.rgb;
        #else
        ao = normalize(inclr.rgb);
        #endif
    }else{
        ao = ceil(inclr.rgb);
    }
    
    
    indiff *= AO == ON ? mix(inclr.rgb, ao, light) : ao;
    
}
